#ifndef _AX25UI_H_
#define _AX25UI_H_

int decode_frame(unsigned char *in, unsigned char *out, int in_length, unsigned char *callsign);
int encode_frame(unsigned char *in, unsigned char *out, int in_length, char FrameType, unsigned char *callsign);
int bit_stuff(unsigned char *out, unsigned char *in, int in_length, int *out_length);
int bit_unstuff(unsigned char *out, unsigned char *in, int in_length, int *out_length);
int encode_ax25(unsigned char *out, unsigned char *in, int in_length, int *out_length, unsigned char rssi, unsigned char hferr, unsigned char *callsign, unsigned char *dbg);
int decode_ax25(unsigned char *out, unsigned char *in, int in_length, int *out_length, unsigned char *rssi, unsigned char *hferr, unsigned char *callsign);
int check_ax25_buffer(ring_buffer *buf, unsigned char *ax25_data, int *ax25_len);
/*
typedef struct ax25_packet_s
{
  int data_size;
  unsigned char *data;
  struct ax25_packet_s *next;
} ax25_packet_t;
*/

#define Init_SRT			550	//Initial Smoothed round trip time in ms
#define NumberOfRetries			25	//how many times should the ax25 retry something before it should give up?

#define PID				0xF0	//this is the pid field of every I_frame

#define Command				0	//Defines the frame type, either a command frame or a response frame
#define Response			1

#define DL_CONNECT_Confirm 		0
#define DL_CONNECT_Indication 		1
#define DL_CONNECT_Request 		2
#define DL_ERROR_Indication 		3
#define DL_DISCONNECT_Indication 	4
#define DL_DISCONNECT_Confirm 		5
#define DL_DISCONNECT_Request 		6
#define DL_DATA_Indication		7
#define DL_DATA_Request			8
#define DL_UNIT_DATA_Indication		9
#define DL_UNIT_DATA_Request		10
#define DL_FRAME_Acked			11	//this is used to tell layer3 that the last frame it sent has been acknowledge
#define LM_SEIZE_Request		12
#define LM_SEIZE_Confirm		13
#define PL_RESET_Request		14
#define PL_TRANSMIT_Request		15 

#define SABM_Frame			0
#define DISC_Frame			1
#define DM_Frame			2
#define UA_Frame			3
#define UI_Frame			4
#define XID_Frame			5
#define TEST_Frame			6

#define RR_Frame			7
#define RNR_Frame			8
#define REJ_Frame			9
#define SREJ_Frame			10

#define I_Frame				11

#define FALSE				0
#define TRUE				1

#define TNC_MAX_LENGTH			256

#endif
