#include <stdio.h>
#include <time.h>
#include "beacon.h"
  
int beaconCount = 0;
  
void beacon_decode(char *data, int data_len) {
   FILE *f;
   time_t now;
   int count;
   char bat_volt[4];
   char sw[4];
   char last_ham[7];
   char sponsor[24];
   char *current_time;
   char *beacon_time;
   com_beacon_data_t com_beacon;
   adcs_beacon_data_t adcs_beacon;
   eps_beacon_data_t eps_beacon;
   pl_beacon_data_t pl_beacon;
   log_beacon_data_t log_beacon;
   cdh_beacon_data_t cdh_beacon;

   char buf[500];

   count = 33;
   memcpy(bat_volt, data+count, 3);
   bat_volt[3] = '\0';

   count = 41;
   memcpy(sw, data+count, 3);
   sw[3] = '\0';

   count = 54;
   memcpy(last_ham, data+count, 6);
   last_ham[6] = '\0';

   count = 61;
   memcpy(sponsor, data+count, 24);
   sponsor[24] = '\0';

   count = 86;
   memcpy(&cdh_beacon, data+count, sizeof(cdh_beacon_data_t));
   count += sizeof(cdh_beacon_data_t); // size = 20, count = 106

   memcpy(&log_beacon, data+count, sizeof(log_beacon_data_t));
   count += sizeof(log_beacon_data_t); // size = 2, count = 108

   memcpy(&eps_beacon, data+count, sizeof(eps_beacon_data_t));
   count += sizeof(eps_beacon_data_t); // size = 40, count = 148

   memcpy(&adcs_beacon, data+count, sizeof(adcs_beacon_data_t));
   count += sizeof(adcs_beacon_data_t);// size = 22, count = 170

   memcpy(&com_beacon, data+count, sizeof(com_beacon_data_t));
   count += sizeof(com_beacon_data_t);// size = 11, count = 181

   memcpy(&pl_beacon, data+count, sizeof(pl_beacon_data_t));
   count += sizeof(pl_beacon_data_t);// size = 4, count = 185
   //(PLIncomingHandler(1234, (char*)&pl_beacon, 3);

   
   /*f = fopen("beacon_raw.txt", "ab");
   if(f != NULL) {
      fseek(f,0,SEEK_END);
   } else {
      Application->MessageBox("Could not open beacon_raw.txt", NULL, NULL);
   }*/

   f = fopen("beacon.txt", "a");
   if(f != NULL) {
      fseek(f,0,SEEK_END);
      if(beaconCount == 0) {
         fprintf(f,"                    | Header                                     | Valid | ");
         fprintf(f,"CDH                                       Mem                            | ");
         fprintf(f,"LOG/FLASH     | ");
         fprintf(f,"EPS                                                              Thresholds                                     PDUsta        Thresholds_CDH/Warn            | ");
         fprintf(f,"ADCS                                                                                             | ");
         fprintf(f,"COM                 packets                            | ");
         fprintf(f,"PL                    \n");

         fprintf(f,"                    | Bat  SW   HAM     Sponsor                  | LEACP | ");
         fprintf(f,"SW  Boots  Uptime    CurrentTime          Free     Largest  Temp1  Temp2 | ");
         fprintf(f,"Free     Stat | ");
         fprintf(f,"I_Bat   V_SA  BAT1_T  BAT2_T  V_BAT  I_PCU   T_PRU   V5_M  V3_M  T_BAT  V_BATs  V_BAT0  V_BAT1  V_BAT2  V_BAT3  123456  TEMP  V_BAT0  V_BAT1  V_BAT2  V_BAT3 | ");
         fprintf(f,"Mode  Gyro                     Temp                     Mag          Bdot         Act            | ");
         fprintf(f,"LastRSSI   AvgRSSI  RXtot  RXok   TX     HFerr  Temp   | ");
         fprintf(f,"                      \n");

         fprintf(f,"--------------------+--------------------------------------------+-------+-");
         fprintf(f,"-------------------------------------------------------------------------+-");
         fprintf(f,"--------------+-");
         fprintf(f,"-------------------------------------------------------------------------------------------------------------------------------------------------------------+-");
         fprintf(f,"-------------------------------------------------------------------------------------------------+-");
         fprintf(f,"-------------------------------------------------------+-");
         fprintf(f,"----------------------\n");
      }

      time(&now);
      current_time = ctime(&now);
      current_time[19] = 0;
      fprintf(f,"%s | %s  %s  %s  %s | %d%d%d%d%d | ",
         current_time,bat_volt,sw,last_ham,sponsor,
         (cdh_beacon.beacon_valid&0x10)>>4,(cdh_beacon.beacon_valid&0x08)>>3,
         (cdh_beacon.beacon_valid&0x04)>>2,(cdh_beacon.beacon_valid&0x02)>>1,
         cdh_beacon.beacon_valid&0x01);
      beacon_time = ctime((time_t*) &cdh_beacon.cur_time);
       beacon_time[19] = 0;      
      fprintf(f,"%02X  %7d  %5ds  %s %7d  %7d  %2.2f  %2.2f | ",
         cdh_beacon.sw_ver_id,cdh_beacon.boots,cdh_beacon.uptime,
         beacon_time,cdh_beacon.free_mem*32,
         cdh_beacon.largest_mem*32,((double)cdh_beacon.temp0)/100.0,
         ((double)cdh_beacon.temp1)/100.0);
      fprintf(f,"%7d  %02X   | ",log_beacon.flash_free*32,log_beacon.flash_status);
      fprintf(f,"%6.2f  %4.2f  %5.2f   %5.2f   %4.2f   %6.2f  %6.2f  %4.2f  %4.2f  %5.2f  %6.2f  %6.2f  %6.2f  %6.2f  %6.2f  %d%d%d%d%d%d  %4d  %6.2f  %6.2f  %6.2f  %6.2f | ",
         (eps_beacon.I_BAT-320)*3.3/1023.0*1000.0,eps_beacon.V_SA*3.3/1023.0*(41.0/27.0),
         ((eps_beacon.BAT1_T*3.3/1023.0)-0.5)*100.0,((eps_beacon.BAT2_T*3.3/1023.0)-0.5)*100.0,
         eps_beacon.V_BAT*3.3/1023.0*(39.0/15.0),(eps_beacon.I_PCU-320)*3.3/1023.0*1000.0,
         ((eps_beacon.T_PRU*3.3/1023.0)-0.5)*100,eps_beacon.V_MEAS_5*3.3/1023.0*(40.0/24.0),
         eps_beacon.V_MEAS_3*3.3/1023.0*(101.0/91.0),((eps_beacon.T_BAT_Threshold*3.3/1023.0)-0.5)*100.0,
         eps_beacon.V_BAT_Threshold_shutdown*3.3/1023.0*(39.0/15.0),eps_beacon.V_BAT_Threshold_1*3.3/1023.0*(39.0/15.0),
         eps_beacon.V_BAT_Threshold_2*3.3/1023.0*(39.0/15.0),eps_beacon.V_BAT_Threshold_3*3.3/1023.0*(39.0/15.0),
         eps_beacon.V_BAT_Threshold_4*3.3/1023.0*(39.0/15.0),eps_beacon.PDUState&0x01,(eps_beacon.PDUState&0x02)>>1,
         (eps_beacon.PDUState&0x04)>>2,(eps_beacon.PDUState&0x08)>>3,(eps_beacon.PDUState&0x10)>>4,
         (eps_beacon.PDUState&0x20)>>5,eps_beacon.TEMP_Disable,eps_beacon.V_BAT_Warn_1*3.3/1023.0*(39.0/15.0),
         eps_beacon.V_BAT_Warn_2*3.3/1023.0*(39.0/15.0),eps_beacon.V_BAT_Warn_3*3.3/1023.0*(39.0/15.0),
         eps_beacon.V_BAT_Warn_4*3.3/1023.0*(39.0/15.0));
      fprintf(f,"%4d  %3d %3d %3d %3d %3d %3d  %3d %3d %3d %3d %3d %3d  %3d %3d %3d  %3d %3d %3d  %4d %4d %4d | ",
         adcs_beacon.mode, adcs_beacon.gyro[0], adcs_beacon.gyro[1], adcs_beacon.gyro[2], adcs_beacon.gyro[3],
         adcs_beacon.gyro[4], adcs_beacon.gyro[5], adcs_beacon.temp[0], adcs_beacon.temp[1], adcs_beacon.temp[2],
         adcs_beacon.temp[3], adcs_beacon.temp[4], adcs_beacon.temp[5], adcs_beacon.mag[0], adcs_beacon.mag[1],
         adcs_beacon.mag[2], adcs_beacon.bdot[0], adcs_beacon.bdot[1], adcs_beacon.bdot[2], adcs_beacon.act[0],
         adcs_beacon.act[1], adcs_beacon.act[2]);
      fprintf(f,"%6.1fdBm  %7d  %5d  %5d  %5d  %5.1f  %6.2f | ",54*(com_beacon.last_rssi*3.3/256.0)-172,
         com_beacon.avg_rssi,
         com_beacon.nr_rx_packets,com_beacon.nr_rx_ok_packets,com_beacon.nr_tx_packets,
         (com_beacon.last_hferr*3.3/256.0)*28.3019-73.0,((com_beacon.last_temp*3.3/256.0)-0.425)/0.00625);
      fprintf(f,"%6.2f  %6.2f  %6.2f\n",
         (3300.0*pl_beacon.temp0/512.0-424.0)/6.25,
         (3300.0*pl_beacon.temp1/512.0-424.0)/6.25,
         (3300.0*pl_beacon.temp2/512.0-424.0)/6.25);
      fclose(f);
      beaconCount++;
      if(beaconCount == 20) {
         beaconCount = 0;
         fprintf(f,"\n");
      }
   } else {
      printf("Could not open beacon.txt\n");
   }
}
