#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "buffers.h"
#include "ax25.h"
#include "memdump.h"
#include "beacon.h"


int main(int argc, char *argv[])
{
  FILE* raw_beacon_data;
  ring_buffer *rx_ax25_buffer;
  int bytes_read;
  int ax25_len;
  int raw_len;
  int result;
  char data_buffer[50];
  char ax25_data[1024];
  char raw_data[1024];
  double rssi_vol, hferr_vol, rssi, hferr;
  unsigned char last_hferr;
  unsigned char last_rssi;
  unsigned char callsign[10];
  short int cmd;
 

  // Initialize the ring buffer
  rx_ax25_buffer = (ring_buffer*) malloc(sizeof(ring_buffer));
  rx_ax25_buffer->size = 2048;
  rx_ax25_buffer->start_offset = 0;
  rx_ax25_buffer->stop_offset = 0;
  rx_ax25_buffer->mask = rx_ax25_buffer->size-1;
  rx_ax25_buffer->data = (unsigned char*) malloc(rx_ax25_buffer->size);

  raw_beacon_data = fopen("raw_beacon_data.bin", "ab+");
   if(!raw_beacon_data){
     raw_beacon_data=fopen("raw_beacon_data.bin", "wb+");
     if(!raw_beacon_data){
       printf("COM_CONTROL# Could not open file raw_beacon_data.bin\n");
       return 1;
     }
   }
   
   // Read at most 50 bytes at a time and put them into the ring buffer
   while((bytes_read = fread(data_buffer, 1, 50, raw_beacon_data)) > 0){
     printf("%d bytes read from file\n", bytes_read);
     buf_write(rx_ax25_buffer, data_buffer, bytes_read);
     check_ax25_buffer(rx_ax25_buffer, ax25_data, &ax25_len);
     
     if(ax25_len > 0){
       printf("%d ax25 bytes read from ring buffer\n", ax25_len);
       memset(callsign,0,10);
       result = decode_ax25(raw_data, ax25_data, ax25_len, &raw_len, &last_rssi, &last_hferr, callsign);

       // Calculate the RSSI value
       rssi_vol = 3.3*last_rssi/256;
       rssi = -172 + 54*rssi_vol;
       // Calculate HFERR value
       hferr_vol = 3.3*last_hferr/256;
       hferr = -73 + 28.3019*hferr_vol;

       if(result == 0)
         printf("Checksum match, raw_length %d \nLast uplink RSSI %f dBm \nLast uplink HFERR %f kHz \nLast uplink callsign: %s  \n", raw_len, rssi, hferr, callsign );
         else
         printf("Checksum mismatch, raw_length %d \nLast uplink RSSI %f dBm \nLast uplink HFERR %f kHz \nLast uplink callsign: %s  \n", raw_len, rssi, hferr, callsign );
       memdump(raw_data, raw_len);
       memcpy(&cmd,raw_data,2);
       printf("Command ID: 0x%04x\n", cmd);
       if(cmd == 0x7777)
         beacon_decode(raw_data, raw_len);
     }  
   }


  fclose(raw_beacon_data);
  #ifdef WIN32
  system("PAUSE");	
  #endif
  return 0;
}
