#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "buffers.h"

int memdump(char *start, int numbytes){
  int offset = 0;
  int i = 0;
  int j = 0;
  int running = 1;
  char temp[20];

  if(numbytes < 1)
    return 0;  
  
  while(running){
    // First 8 hex chars in the line
    for(i=offset;i<8+offset;i++){
      if(i >= numbytes){
        running = 0;
        for(j=i;j<8+offset;j++)
          printf("   ");
        //sprintf(temp, "     ");
        i = offset + 8;
        break;
      }
      printf("%02x ",*(start+i)&255);
      
    }

    //sprintf(temp, " ");
    printf(" ");
    // Last 8 hex chars in the line
    for(;i<16+offset;i++){
      if(i >= numbytes){
        for(j=i;j<16+offset;j++)
          printf("   ");
        //sprintf(temp, "     ");
        break;
      }
      printf("%02x ",*(start+i)&255);
      
    }

    printf("  ");
    // First 8 ascii chars in line
    for(i=offset;i<8+offset;i++){
      if(i >= numbytes){
        for(j=i;j<8+offset;j++)
          printf(" ");
        //sprintf(temp, " ");
        i = offset + 8;
        break;
      }
      if(*(start+i) > 32){
        printf("%c",*(start+i)&255);
        
      }
      else
        //sprintf(temp, ".");
        printf(".");
    }

    //sprintf(temp, " ");
    printf(" ");
    // Last 8 ascii chars in line
    for(;i<16+offset;i++){
      if(i >= numbytes){
        for(j=i;j<16+offset;j++)
          //sprintf(temp, " ");
          printf(" ");
        break;
      }
      if(*(start+i) > 32){
        printf("%c",*(start+i)&255);
        
      }
      else
        printf(".");
      //sprintf(temp, ".");
    }
    offset += 16;
    printf("\n");
    //sprintf(temp, "\r\n");
  }

  // sprintf(temp, "\r\ni=%i, j=%i\r\n",i,j);
  // strcat(buf, temp);
  return 0;
}

/***
 *@memdump_ring
 *Takes numbytes of data from the ring_buffer
 *inBuf and memdumps them in outBuf as a string
 *that can be printet to a memobox
 *The ring_offset must be given relative to
 *the start_offset and not relative to the
 *beginning of the ring_buffer
 *Return 0 for succes or -1 for error
 **/
int memdump_ring(char *outBuf, ring_buffer *inBuf, int ring_offset, int numbytes){
  int offset = 0;
  int i = 0;
  int j = 0;
  int running = 1;
  char temp[20];
  unsigned char ch;

  *outBuf=0;
  
  if(numbytes < 1)
    return 0;  
  
  while(running){  
    // First 8 hex chars in the line
    for(i=offset;i<8+offset;i++){
      if(i >= numbytes){
        running = 0;
        for(j=i;j<8+offset;j++)
          strcat(outBuf, "   ");
        //sprintf(temp, "     ");
        i = offset + 8;
        break;
      }
      peekbyte(inBuf, &ch, (ring_offset+i)&inBuf->mask);
      sprintf(temp, "%02x ", ch&255);
      strcat(outBuf, temp);
    }

    //sprintf(temp, " ");
    strcat(outBuf, " ");
    // Last 8 hex chars in the line
    for(;i<16+offset;i++){
      if(i >= numbytes){
        for(j=i;j<16+offset;j++)
          strcat(outBuf, "   ");
        //sprintf(temp, "     ");
        break;
      }
      peekbyte(inBuf, &ch, (ring_offset+i)&inBuf->mask);
      sprintf(temp, "%02x ", ch&255);
      strcat(outBuf, temp);
    }

    strcat(outBuf, "  ");
    // First 8 ascii chars in line
    for(i=offset;i<8+offset;i++){
      if(i >= numbytes){
        for(j=i;j<8+offset;j++)
          strcat(outBuf, " ");
        //sprintf(temp, " ");
        i = offset + 8;
        break;
      }
      peekbyte(inBuf, &ch, (ring_offset+i)&inBuf->mask);
      if(((ch&255)>32)&&(!(ch&128))){
        sprintf(temp, "%c", ch&255);
        strcat(outBuf, temp);
      }
      else
        //sprintf(temp, ".");
        strcat(outBuf, ".");
    }

    //sprintf(temp, " ");
    strcat(outBuf, " ");
    // Last 8 ascii chars in line
    for(;i<16+offset;i++){
      if(i >= numbytes){
        for(j=i;j<16+offset;j++)
          //sprintf(temp, " ");
          strcat(outBuf, " ");
        break;
      }
      peekbyte(inBuf, &ch, (ring_offset+i)&inBuf->mask);
      if(((ch&255)>32)&&(!(ch&128))){
        sprintf(temp, "%c", ch&255);
        strcat(outBuf, temp);
      }
      else
        strcat(outBuf, ".");
      //sprintf(temp, ".");
    }
    offset += 16;
    strcat(outBuf, "\n");
    //sprintf(temp, "\r\n");
  }

  // sprintf(temp, "\r\ni=%i, j=%i\r\n",i,j);
  // strcat(outBuf, temp);
  return 0;
}
