/*
         ########################################
         #          TELEMETRINO 1.0             #
         #                                      #
         #       http://www.cacharreo.es        #
         ########################################

         Telemetria en APRS con UIDIGI y Arduino
 
 
 Este software se libera bajo licencia GPL versión3
 
 */

// hay que descargar y tener estas librerias antes de compilar el sketch

#include <MsTimer2.h> 
#include <avr/wdt.h>


//  ********** definicion e variables globales ********************

/*
La siguiente línea configura el indicativo de la estación, debe sustituirse por el indicativo propio de cada estación.
Para las estaciones autónomas de telemetría que no sean digirepetidores o estaciones méteo, recomendamos usar el SSID -13.
El indicativo debe constar necesariamente de 9 caracteres, completando lo que falta con espacios, de lo contrario no funciona.

*/

char cadena[4][80]= {":EA1V-3   :EQNS.0,0.0785,0,0,0.488,-40,0,0.488,-40,0,0.488,-40,0,0.098,0",
                     ":EA1V-3   :UNIT.Volt,Grd,Grd,Grd,Volt,ON,ON,ON,ON,ON,ON,ON,ON",
                     ":EA1V-3   :PARM.TensionA,TempEXT,TempINT,TempTRX,TensionB,1,2,3,4,5,6,7,8",
                     ":EA1V-3   :BITS.00000000,Telemetrino EA1V-3"};
int  tiempobaliza = 1800;                     // Retardo en segundos entre telemetrias
int  espaciadomsgcfg = 10;                    // Espacioado entre msg configuracion
int  analoginf[6]={    0,  477,  477,  477,    0};
int  analogsup[6]={ 1023,  732,  732,  732, 1023};

char cadenatelemetriaAPRS[36] = "T#000,000,000,000,000,000,00000000";
int  segundos = 0;
int  segundosmsg = 0;
int  segundosanterior = 0;
int  tiempobalizamsg;
byte contadortx = 0;
byte numerobaliza = 0;
byte digitalinputs = 0;
int  analog[7];


void setup() {
  wdt_disable();                                       // desactiva el watchdog para el arranque
  MsTimer2::set(1000, reloj);                          // initialize timer2, and set a 1S period
  MsTimer2::start();                           
  tiempobalizamsg = (tiempobaliza + (tiempobaliza/2)); // calculo tiempo envio mensages

  Serial.begin(9600);             // inicializa el puerto serie a 9600bps. Cambiar este valor a 4800 para el OpenTracker+

  pinMode (3, INPUT);      //   definicion Entradas digitales
  pinMode (4, INPUT);
  pinMode (5, INPUT);
  pinMode (6, INPUT);
  pinMode (7, INPUT);      
  pinMode (8, INPUT);
  pinMode (9, INPUT);
  pinMode (10, INPUT);
  
  delay (5000);
  //Serial.print("!");                          // Descomentar esta linea para usar con el OpenTracker+   
  Serial.println(":BLN1     :TELEMETRINO 1.0 www.cacharreo.es");
  for (int i=0; i>=3 ;i++){
     delay (5000);  
     //Serial.print("!");                          // Descomentar esta linea para usar con el OpenTracker+
     Serial.println(cadena[i]);
  }
  
  wdt_enable(WDTO_2S);                        // Activa el watchdog con un tiempo de 2000ms
  lecturaentradas();
  formateotelemetria();
  transmision();
  contadortx++; 

}
// *************** Reloj por interrupción del TIMER1 ***************************************
void reloj(){                    //Interrupción del Timer1
  segundos++;                        
  segundosmsg++;
}

void lecturaentradas(){
  // lectura de las entradas analogicas de 10 bit
  for (int i=0; i <= 5; i++){
    analog[i] = analogRead(i);     
    delay (10);
  }
  // lectura de las entradas digitales  de la 3 a la 10, y escritura en un solo byte
  digitalinputs = 0 ;
  bitWrite(digitalinputs,0,digitalRead(3));
  bitWrite(digitalinputs,1,digitalRead(4));
  bitWrite(digitalinputs,2,digitalRead(5));
  bitWrite(digitalinputs,3,digitalRead(6));
  bitWrite(digitalinputs,4,digitalRead(7));
  bitWrite(digitalinputs,5,digitalRead(8));
  bitWrite(digitalinputs,6,digitalRead(9));
  bitWrite(digitalinputs,7,digitalRead(10));
}

void contador(){                             // Funcion de contador de balizas enviadas de 0 a 254
  if (numerobaliza < 255) numerobaliza++;   // si es igual o superior a 255 lo pone a 0 el contador
  else numerobaliza=0;                       // incremento en 1 para el contador de numero de baliza 
} 

/* TELEMETRIA APRS ******************************************************************************************/
void formateotelemetria (){
  // Conversion de las variables e iyeccion del texto en la cadena preformateada de telemetria
  // Definicion de variables
  byte decimal[7];
  decimal[0] = numerobaliza;
  //mapeo a 8 bit de las variables analogicas de 10 bit
  for (byte i=0 ; i <= 4; i++){
    if (analog[i] <= analoginf[i]){
      decimal[i+1] = 0;
    }
    else if (analog[i] >= analogsup[i]){
      decimal[i+1] = 255;
    }
    else{
      decimal[i+1]=map(analog[i], analoginf[i], analogsup[i], 0, 255);
    }
  }

  for (byte i=0; i <= 5; i++){                                        //loop para convertir el contador y las 5 variables analogicas
    byte centenas =  decimal[i] / 100;                                //calculo del valor de centenas
    byte decenas  = (decimal[i] - (centenas * 100)) / 10;             //calculo del valor de decenas
    byte unidades =  decimal[i] - (centenas * 100) - (decenas * 10);  //calculo del valor de unidades
    byte y= i + (i*3) + 2;                                            //posicion inicial del campo a rellenar
    cadenatelemetriaAPRS[y]  =  48 + centenas;                        //escritura del valor ASCII de centenas
    cadenatelemetriaAPRS[y+1]=  48 + decenas;                         //escritura del valor ASCII de decenas
    cadenatelemetriaAPRS[y+2]=  48 + unidades;                        //escritura del valor ASCII de unidades
  }                

  for (byte i=0; i <= 7; i++){                                         //loop para crear los 8 bit de las entradas digitales
    if ( bitRead(digitalinputs,i) == 1)                                //si el valor dle bit es 1
        cadenatelemetriaAPRS[i+26] = 49;                               //escribe "1" en ASCII
    else  cadenatelemetriaAPRS[i+26] =48;                              //sino escribe "0" em ASCCI
  }  
}
/**************************************************************************************************************/

void transmision(){                            // Funcion para la transmision de la baliza 
  //Serial.print("!");                          // Descomentar esta linea para usar con el OpenTracker+
  Serial.println(cadenatelemetriaAPRS);        // Escritura en el puerto serie  
  contador();                                  // Funcion de incremento del contador de numero de telemetria  
}

void transmisionmsg(){                         // Funcion para la transmision de los mensages de autoconfiguracion
  contadortx++; 
  if (contadortx == espaciadomsgcfg){
    //Serial.print("!");                       // Descomentar esta linea para usar con el OpenTracker+
    Serial.println(cadena[0]);
  }
  else if (contadortx == (espaciadomsgcfg *2)){
    //Serial.print("!");                         // Descomentar esta linea para usar con el OpenTracker+
    Serial.println(cadena[1]);
  }
  else if (contadortx == (espaciadomsgcfg *3)){
    //Serial.print("!");                       // Descomentar esta linea para usar con el OpenTracker+
    Serial.println(cadena[2]);
  }
  else if (contadortx >= (espaciadomsgcfg *4)){
    //Serial.print("!");                         // Descomentar esta linea para usar con el OpenTracker+
    Serial.println(cadena[3]);
    contadortx=0;  
  }else{
  }     
}

/***********************************************************************************************/
void loop(){
  wdt_reset();                              // reset del watchdog de manera periodica
  lecturaentradas();                        // lectura de entradas analogicas y digitales

  if (segundos >= tiempobaliza ){           // comparacion del contador de TX telemetria
    formateotelemetria();                   // si el contador llega al valor definido en tiempobaliza
    transmision();                          // ejecuta las funciones de telemetria y transmision 
    segundos=0;
  }

  if (segundosmsg >= tiempobalizamsg){      // comparacion del contador de TX de autoconfiguracion
    transmisionmsg();                       // si el contador llega al valor definido en tiempobalizamsg
    segundosmsg = segundos;                 // ejecuta la funcion de transmision de los msg de autoconfiguracion
  }

}
